//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

int Funkcja(int argument){return argument;}

typedef int (*TFunkcja)(int);

void FunkcjaWywolujacaFunkcje(TFunkcja funkcja,int argument)
{
    int wf=funkcja(argument);
    ShowMessage(IntToStr(wf));
}

//------

class TKlasa
{
    public:
        int Metoda(int argument) const{return argument;}
        static MetodaStatyczna(int argument){return argument;}

    /*** Problem 2 ***/
    public:
        int MetodaOtaczajacaFunkcje(int argument) const
        {
            return Funkcja(argument);
        }
};

typedef int (TKlasa::*TMetoda)(int) const; //tu jest ukryty argument - wskaznik do instancji obiektu

void FunkcjaWywolujacaMetode(TKlasa* pobiekt,TMetoda metoda,int argument)
{
    int wm=(pobiekt->*metoda)(argument);
    ShowMessage(IntToStr(wm));
}

void FunkcjaWywolujacaMetode(TKlasa obiekt,TMetoda metoda,int argument)
{
    int wm=(obiekt.*metoda)(argument);
    ShowMessage(IntToStr(wm));
}

//------

//Problem 1: najprostsze rozwiazanie
int FunkcjaOtaczajacaMetode(int argument)
{
    TKlasa obiekt; //to moglby byc obiekt globalny
    return obiekt.Metoda(argument);
}

//Problem 2: naturalne rozwiazanie
//dodanie do klasy metody wywolujacej funkcje (patrz wyzej)

//------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    int wf=Funkcja(1);
    ShowMessage(IntToStr(wf));

    TKlasa obiekt;
    int wm=obiekt.Metoda(2);
    ShowMessage(IntToStr(wm));

    FunkcjaWywolujacaFunkcje(Funkcja,3);
    FunkcjaWywolujacaFunkcje(TKlasa::MetodaStatyczna,4); //wskaznik do metody statycznej = wskaznik do funkcji

    FunkcjaWywolujacaMetode(&obiekt,TKlasa::Metoda,5);
    FunkcjaWywolujacaMetode(obiekt,TKlasa::Metoda,6);

    TKlasa* pobiekt=new TKlasa();
    FunkcjaWywolujacaMetode(pobiekt,TKlasa::Metoda,7);

    //Problem 1: przekazac wskaznik do metody do funkcji FunkcjaWywolujacaFunkcje
    FunkcjaWywolujacaFunkcje(FunkcjaOtaczajacaMetode,8);

    //Problem 2: przekazac wskaznik do funkcji do funkcji FunkcjaWywolujacaMetode
    FunkcjaWywolujacaMetode(obiekt,TKlasa::MetodaOtaczajacaFunkcje,9);
}

//---------------------------------------------------------------------------

//template<typename T> typedef int (T::*TSzablonMetoda)(int) const; //to nie dziala w Borland

template<typename T> void SzablonFunkcjaWywolujacaMetode(T* pobiekt,int (T::*metoda)(int) const,int argument)
{
    int wm=(pobiekt->*metoda)(argument);
    ShowMessage(IntToStr(wm));
}

template<typename T> void SzablonFunkcjaWywolujacaMetode(T obiekt,TMetoda metoda,int argument)
{
    int wm=(obiekt.*metoda)(argument);
    ShowMessage(IntToStr(wm));
}

//Problem 1: najprostsze rozwiazanie
template<typename T> int SzablonFunkcjaOtaczajacaMetode(int argument)
{
    T obiekt; //to moglby byc obiekt globalny
    return obiekt.Metoda(argument);
}

//Problem 2: bardziej eleganckie rozwiazanie (nie trzeba modyfikowac klasy bazowej)
template<typename T> class TSzablonKlasaPotomna : public T
{
    private:
        TFunkcja funkcja;
    public:
        TSzablonKlasaPotomna(TFunkcja funkcja):funkcja(funkcja){};
        int NowaMetodaOtaczajacaFunkcje(int argument) const
        {
            return funkcja(argument);
        }
};

//--------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
    TKlasa obiekt;
    SzablonFunkcjaWywolujacaMetode<TKlasa>(obiekt,TKlasa::Metoda,10);

    //Problem 1: przekazac wskaznik do metody do funkcji FunkcjaWywolujacaFunkcje
    FunkcjaWywolujacaFunkcje(SzablonFunkcjaOtaczajacaMetode<TKlasa>,11);

    //Problem 2: przekazac wskaznik do funkcji do funkcji FunkcjaWywolujacaMetode
    TSzablonKlasaPotomna<TKlasa> obiektPotomnej(Funkcja);
    FunkcjaWywolujacaMetode(obiektPotomnej,(TMetoda)(TSzablonKlasaPotomna<TKlasa>::NowaMetodaOtaczajacaFunkcje),12);
}
//---------------------------------------------------------------------------

/*
class TKlasa
{
    public:
        int Metoda(int argument) const{return argument;}
};
*/


typedef int (__closure *TMetodaJakFunkcja)(int);

void FunkcjaWywolujacaMetodeJakFunkcje(TMetodaJakFunkcja metoda,int argument)
{
    int wmjf=metoda(argument);
    ShowMessage(IntToStr(wmjf));
}

void __fastcall TForm1::Button3Click(TObject *Sender)
{
    TKlasa obiekt;
    TMetodaJakFunkcja metodajakfunkcja;
    metodajakfunkcja=obiekt.Metoda; //ta linia nie moze byc dolaczona do poprzedniej, bo blad kompilatora

    int wmjf=metodajakfunkcja(14);
    ShowMessage(IntToStr(wmjf));

    FunkcjaWywolujacaMetodeJakFunkcje(metodajakfunkcja,15);
}
//---------------------------------------------------------------------------

